
// WebRTC_ServerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WebRTC_Server.h"
#include "WebRTC_ServerDlg.h"
#include "afxdialogex.h"
#include <winsock2.h> 

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


VOID Dbg( CHAR* pszStr, ... )
{
	char szData[ MAX_PATH ] = "[SC] ";

	va_list args;

	va_start( args, pszStr );

	_vsnprintf( szData + 5, sizeof( szData ) - 1, pszStr, args );

	va_end( args );

    strcat( szData, "\n" );

	OutputDebugString( szData );
}


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CWebRTC_ServerDlg dialog




CWebRTC_ServerDlg::CWebRTC_ServerDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CWebRTC_ServerDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWebRTC_ServerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_EDIT_PORT_1, m_editServerNumber);
	DDX_Control(pDX, IDC_EDIT_NUM, m_editServerPort);
	DDX_Control(pDX, IDC_EDIT_NUM2, m_editAlreadyUsed);
}

BEGIN_MESSAGE_MAP(CWebRTC_ServerDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_START, &CWebRTC_ServerDlg::OnBnClickedButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, &CWebRTC_ServerDlg::OnBnClickedButtonStop)
END_MESSAGE_MAP()


// CWebRTC_ServerDlg message handlers

BOOL CWebRTC_ServerDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	HRESULT hr = CoInitialize( NULL );

	for ( ULONG i = 0 ; i< 16; i ++ ) {

		m_pChatRoomDev[i] = NULL;
	}	

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );

	m_editServerPort.SetWindowTextA("8888");

	m_editServerNumber.SetWindowTextA("4");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWebRTC_ServerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWebRTC_ServerDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}

}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWebRTC_ServerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CWebRTC_ServerDlg::OnDestroy()
{
	CDialogEx::OnDestroy();

	// TODO: Add your message handler code here
	if ( m_pChatRoomDev ) {

		QCAP_DESTROY_WEBRTC_CHATROOM( m_pChatRoomDev );
	}

	CoUninitialize();
}


void CWebRTC_ServerDlg::OnBnClickedButtonStart()
{
	// TODO: Add your control notification handler code here
	CString  chatroon_port, chatter_num;	

	char buff[32];

	m_editServerPort.GetWindowTextA(chatroon_port);

	m_editServerNumber.GetWindowTextA(chatter_num);
	
	if ( chatroon_port.GetLength() == 0 || chatter_num.GetLength() == 0  ) {

		MessageBox("Parameter is NULL");

		return;
	}

	for ( ULONG i = 0 ; i< atoi(chatter_num); i ++ ) {

		if ( !m_pChatRoomDev[i] ) {
	
			QCAP_CREATE_WEBRTC_CHATROOM( atoi(chatroon_port) + i, &m_pChatRoomDev[i] );
		}
	}

	sprintf( buff, " %d - %d ", atoi(chatroon_port), atoi(chatroon_port) + atoi(chatter_num) - 1 );

	m_editAlreadyUsed.SetWindowTextA(buff);

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( TRUE );
}


void CWebRTC_ServerDlg::OnBnClickedButtonStop()
{
	// TODO: Add your control notification handler code here
	for ( ULONG i = 0 ; i< 16; i ++ ) {

		if ( m_pChatRoomDev[i] ) {

			QCAP_DESTROY_WEBRTC_CHATROOM( m_pChatRoomDev[i] );

			m_pChatRoomDev[i] = NULL;
		}
	}

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );

}
